state GreatSwampSpells in W3MagicVigil
{
	var damage_action			 						: W3DamageAction;
	var damage_value									: float;
	var actors 											: array<CActor>;
	var i												: int;
	var main_effect, effect_entity  					: CEntity;
	var target											: CActor; 
	var entities 										: array<CGameplayEntity>; 
	var position 										: Vector;
	var rotation 										: EulerAngles;
	var slotMatrix 										: Matrix;
	var swamp_trap   									: W3GreatSwampTrap;
	var ents_destroy									: array< CEntity >;
	var duration										: float;
	var CustomEffect									: SCustomEffectParams;
	var castDir											: Vector;
	var targetPosition									: Vector;
	var fireball										: W3FireGnosisFireball;
	var boneRotation 									: EulerAngles;
	var bonePosition 									: Vector;
	var dummy											: CEntity;
	var dummy_proj                                      : W3GreatSwampDummy;
	var custom_anim										: name;
	var cast_hand										: CEntity;
	var vector_attach 									: Vector;


	event OnEnterState( prevStateName : name )
	{
		if ( !theSound.SoundIsBankLoaded("monster_golem_dao.bnk") )
		{
			theSound.SoundLoadBank( "monster_golem_dao.bnk", false );
		}
		if ( !theSound.SoundIsBankLoaded("magic_sorceress.bnk") )
		{
			theSound.SoundLoadBank( "magic_sorceress.bnk", false );
		}
		if ( !theSound.SoundIsBankLoaded("monster_scolopendromorph.bnk") )
		{
			theSound.SoundLoadBank( "monster_scolopendromorph.bnk", false );
		}
	
	
		if ( parent.act_signtype == ST_Axii )
		{
			if ( parent.actor && parent.actor.IsAlive() )
			{
				thePlayer.SetSlideTarget( parent.actor );
			}
			else
			{
				thePlayer.AddCustomOrientationTarget( OT_CameraOffset, 'MagicSpells' );
			}
		}
		else
		if ( !theGame.GetInGameConfigWrapper().GetVarValue('magic_spells_main', 'cast_to_camera') )
		{
			if ( !GetMagicVigil().IsAlt() )
			{
				if ( parent.actor && parent.actor.IsAlive() )
				{
					thePlayer.SetSlideTarget( parent.actor );
				}
				else
				{
					thePlayer.AddCustomOrientationTarget( OT_CameraOffset, 'MagicSpells' );
				}
			}
		}
		else
		{
			thePlayer.AddCustomOrientationTarget( OT_CameraOffset, 'MagicSpells' );
		}
		
		if ( parent.alternate )
		{
			thePlayer.PushState( 'camera_hack' );     
		}
		
		cast_spells_axii_greatswamp_init();
	}
	
	event OnCastSpellAnimation( animEventName : name, animEventType : EAnimationEventType, animInfo : SAnimationEventAnimInfo )
	{
		if ( animEventName == 'cast_begin' )
		{
		}
		else if ( animEventName == 'cast_throw' )
		{
			cast_spells_swamp();
			thePlayer.RemoveCustomOrientationTarget( 'MagicSpells' );
		}
		else if ( animEventName == 'cast_end' )
		{
			cast_spells_axii_swamp();
			parent.GotoState( 'Vigil_Dreaming' );
		}
	}
	
	private function cast_spells_swamp()
	{
		switch( parent.spell_name )
		{
			case 'great_swamp_trap':
				{
					theGame.GetEntitiesByTag('great_swamp_trap_spells',ents_destroy);
					for( i=0; i<ents_destroy.Size(); i+=1 )
					{
						ents_destroy[i].AddTimer('destroy_swamp_trap',0.0f);
					} 	
						
					if ( parent.actor && parent.actor.IsAlive() && parent.actor.IsOnGround() && IsRequiredAttitudeBetween(thePlayer, parent.actor, true, false, false)  )
					{
						position = parent.actor.GetWorldPosition();
					}
					else
					{
						position = thePlayer.GetWorldPosition() + thePlayer.GetWorldForward()*3;
						position = find_position_spells( position );
					}
						
					rotation = thePlayer.GetWorldRotation();
					
					duration = 10;
					duration += duration * ( GetMagicVigil().get_magic_spellpower() * 0.5 );
					
					parent.templatename = "dlc\magicspellsrev\data\entities\great_swamp_trap.w2ent";
						
					swamp_trap = (W3GreatSwampTrap)theGame.CreateEntity( (CEntityTemplate)LoadResource( parent.templatename ,true ), TraceFloor( position ), rotation );
					swamp_trap.AddTimer('destroy_swamp_trap', duration );
					swamp_trap.AddTag('great_swamp_trap_spells');
					swamp_trap.AddTag( 'spells_from_sign' );
					
					Spells_drain_stamina( parent.stamina_cost, parent.stamina_delay, parent.signskill );
				}

				break;
			case 'great_swamp_stream':
				{
					parent.templatename = "dlc\magicspellsrev\data\entities\great_swamp.w2ent";
					
					main_effect = (CEntity)theGame.CreateEntity( (CEntityTemplate)LoadResource( parent.templatename ,true ), thePlayer.GetWorldPosition() );
					main_effect.PlayEffect('great_swamp_stream');
					main_effect.CreateAttachment( thePlayer, 'l_weapon');
					main_effect.AddTag('spells_alt_stream');
					
					parent.stamina_cost = CalculateAttributeValue( GetWitcherPlayer().GetSkillAttributeValue( parent.signskill, 'stamina_cost_per_sec', false, true ) * 0.5 );
					parent.stamina_cost += parent.stamina_cost * get_stamina_cost_mult_streams(); 
					
					parent.stamina_delay = CalculateAttributeValue( GetWitcherPlayer().GetSkillAttributeValue( parent.signskill, 'stamina_delay', false, true ) );
					parent.stamina_delay += parent.stamina_delay * get_stamina_delay_mult(); 
					
					register_cancel_input_spells();
					
					cast_spells_stream_swamp();
				}

				break;
			case 'great_swamp_cone':
				{
					thePlayer.CalcEntitySlotMatrix('l_weapon', slotMatrix);
					position = MatrixGetTranslation(slotMatrix);
					rotation = MatrixGetRotation(slotMatrix);
						
					castDir 		= MatrixGetAxisX( slotMatrix );
					castDir.Z 		= ClampF( castDir.Z, 0, 10 );
					targetPosition 	= position + ( 5 * castDir );
						
					parent.hand_aim_position = position;
					parent.hand_aim_direction = castDir;
						
					rotation.Roll = ClampF(rotation.Roll,-100,10);
					
					parent.templatename = "dlc\magicspellsrev\data\entities\great_swamp.w2ent";
					
					main_effect = (CEntity)theGame.CreateEntity( (CEntityTemplate)LoadResource( parent.templatename ,true ), position, rotation );
					main_effect.PlayEffect('great_swamp_cone');
					main_effect.DestroyAfter(10);
			
					dummy_proj = (W3GreatSwampDummy)theGame.CreateEntity( (CEntityTemplate)LoadResource( "dlc\magicspellsrev\data\entities\great_swamp_dummy_projectile.w2ent",true ), position );
					dummy_proj.AddTag( 'spells_custom_projs' );
					dummy_proj.Init(NULL);
					dummy_proj.ShootProjectileAtPosition(0,	5, targetPosition, 10 );
					dummy_proj.DestroyAfter(10);
					
					Spells_drain_stamina( parent.stamina_cost, parent.stamina_delay, parent.signskill );
				}
				
				break;
			default:		
				break;
		}
	}
	
	private entry function cast_spells_axii_greatswamp_init()
	{
		if ( parent.spell_name == 'great_swamp_venom' )
		{
			vector_attach = Vector( -0.2, 0.07, 0.05 );
			
			effect_entity = (CEntity)theGame.CreateEntity( (CEntityTemplate)LoadResource( 'great_swamp_effects' ), thePlayer.GetWorldPosition() ) ;
			effect_entity.CreateAttachment( thePlayer, 'l_weapon', vector_attach );
			effect_entity.PlayEffect( 'greatswamp_shot0' );
			effect_entity.StopEffect( 'greatswamp_shot0' );
			effect_entity.DestroyAfter(5);
			thePlayer.SoundEvent("monster_golem_dao_mv_foley_light");
		}
	}
	private function cast_spells_axii_swamp()
	{
		var venom						: W3GreatSwampVenom;
	
		if ( parent.spell_name == 'great_swamp_venom' )
		{
			if ( parent.actor && parent.actor.IsAlive() && IsRequiredAttitudeBetween(thePlayer, parent.actor, true, false, false) )
			{
				targetPosition = parent.actor.GetBoneWorldPosition( spells_get_pelvis_name( parent.actor ) );
				targetPosition.Z += 0.3;
			
				parent.templatename = "dlc\magicspellsrev\data\entities\great_swamp_venom_projectile.w2ent";

				venom = (W3GreatSwampVenom)theGame.CreateEntity( (CEntityTemplate)LoadResource( parent.templatename, true ), thePlayer.GetWorldPosition() );
				venom.CreateAttachment( thePlayer, 'l_weapon', vector_attach );
				venom.AddTag( 'spells_custom_projs' );
				venom.AddTag( 'spells_from_sign' );
				venom.Init(NULL);
				venom.PlayEffect( 'venom' );
				venom.BreakAttachment();
				venom.ShootProjectileAtPosition(0, 15, targetPosition );
				venom.DestroyAfter(10);

				effect_entity = (CEntity)theGame.CreateEntity( (CEntityTemplate)LoadResource( 'great_swamp_effects' ), thePlayer.GetWorldPosition() ) ;
				effect_entity.CreateAttachment( thePlayer, 'l_weapon', vector_attach );
				effect_entity.PlayEffect( 'greatswamp_shot' );
				effect_entity.DestroyAfter(3);
				
				Spells_drain_stamina( parent.stamina_cost, parent.stamina_delay, parent.signskill );
				
				thePlayer.SetCombatIdleStance( 1.f );
			}
		}
	}
	
	private entry function cast_spells_stream_swamp()
	{
		var damage_action_stream				: W3DamageAction;
		var victims 							: array<CActor>;
		var victim								: CActor;
		var damage 								: float;
		var i									: int;
		var castDir								: Vector;
		var targetPosition						: Vector;
		var position							: Vector;
		var slotMatrix 							: Matrix;
		var effectentity						: CEntity;
		var coll, normal 						: Vector;
		var lastpos 							: Vector;
		var entities							: array<CGameplayEntity>;
		var lastpos2 							: Vector;
	
		while ( true )
		{
			if (  thePlayer.GetStatPercents( BCS_Stamina ) > 0.01f && thePlayer.GetBehaviorVariable	( 'IsCastingSign' ) == 1 )
			{
				thePlayer.CalcEntitySlotMatrix('l_weapon', slotMatrix);
				position = MatrixGetTranslation(slotMatrix);
				
				castDir 		= MatrixGetAxisX( thePlayer.GetBoneWorldMatrixByIndex( thePlayer.GetBoneIndex( 'l_weapon' ) ) );
				targetPosition  = position + ( 6 * castDir );
				
				parent.hand_aim_position = position;
				parent.hand_aim_direction = castDir;
			
				FindGameplayEntitiesInCone( entities, position, VecHeading( castDir ), 25, 6, 100 );
			
				victims = thePlayer.GetNPCsAndPlayersInCone( 6, VecHeading( castDir ), 25, 20, , FLAG_Attitude_Hostile + FLAG_OnlyAliveActors);
				for (i=0; i<victims.Size(); i+=1)	
				{
					victim = (CActor)victims[i];
					if ( GetAttitudeBetween( victim, thePlayer ) == AIA_Hostile && victim.IsAlive() )
					{
						damage = get_damage_value_for_stream( victim, GetMagicVigil().get_magic_spellpower() );
						damage *= theTimer.timeDelta;
					
						damage_action_stream = new W3DamageAction in this;
						damage_action_stream.Initialize(thePlayer,victim,this,thePlayer.GetName()+"_sign",EHRT_None,CPS_SpellPower,false, false, true, false );
						damage_action_stream.SetProcessBuffsIfNoDamage(true);
						
						if ( ( (CNewNPC)victim ).IsShielded( thePlayer ) )
						{
							damage *= 0.5;
						
							if ( ( (CNewNPC)victim ).GetBehaviorVariable( 'bShieldUp' ) == 0.f )
							{
								( (CNewNPC)victim ).SetBehaviorVariable( 'bShieldUp', 1.f );
							}
							
							if ( ( (CNewNPC)victim ).GetStaminaPercents() > 0.1 )
							{
								( (CNewNPC)victim ).DrainStamina(ESAT_FixedValue, 3 );
							}
							else 
							{
								( (CNewNPC)victim ).ProcessShieldDestruction();
							}
						}
						else
						{
							if( RandF()<0.3 ) 
							{ 
								damage_action_stream.AddEffectInfo( EET_Poison, 2 ); 
							}
							if( RandF()<0.1 ) 
							{ 
								damage_action_stream.AddEffectInfo( EET_SpellsSlowDownCritical, 1 ); 
							}
						}
						
						damage_action_stream.AddDamage(theGame.params.DAMAGE_NAME_FIRE, sp_fire_dmg_mod() * damage * 0.6 );
						damage_action_stream.AddDamage(theGame.params.DAMAGE_NAME_POISON, sp_pois_dmg_mod() * damage * 0.6 );
						damage_action_stream.AddEffectInfo( EET_SpellsSlowDownAverage, 1 );
						damage_action_stream.SetIsDoTDamage( theTimer.timeDelta );
							
						damage_action_stream.SetHitAnimationPlayType(EAHA_ForceNo);
						damage_action_stream.SetHitEffect('');
						damage_action_stream.SetHitEffect('', true );
						damage_action_stream.SetHitEffect('', false, true);
						damage_action_stream.SetHitEffect('', true, true);
					
						
						if ( spells_can_dismember( victim ) )
						{
							damage_action_stream.SetForceExplosionDismemberment();
						}
						
						theGame.damageMgr.ProcessAction( damage_action_stream );
						delete damage_action_stream;
					}
				}
				
				if( theGame.GetWorld().SweepTest( position + castDir, targetPosition, 0.3, coll, normal, parent.collisions_stream ) )
				{
					lastpos = coll;
					theGame.GetEntityByTag( 'spells_stream_collision' ).PlayEffectSingle('collision_fx');
				}
				else
				{
					theGame.GetEntityByTag( 'spells_stream_collision' ).StopAllEffects();
				}
				
				if ( !theGame.GetEntityByTag( 'spells_stream_collision' ) )
				{
					effectentity = theGame.CreateEntity( (CEntityTemplate)LoadResource("dlc\magicspellsrev\data\entities\great_swamp_stream_collision.w2ent",true), targetPosition, thePlayer.GetWorldRotation() );
					effectentity.AddTag('spells_stream_collision');
				}
				else
				{
					theGame.GetEntityByTag( 'spells_stream_collision' ).Teleport(lastpos);
				}
				
				GetWitcherPlayer().DrainStamina( ESAT_FixedValue, parent.stamina_cost * theTimer.timeDelta, parent.stamina_delay ); 
			}
			else
			{
				thePlayer.SoundEvent("gui_no_stamina");
				parent.PushState('Vigil_Dreaming');
			}
			
			Sleep( theTimer.timeDelta );
		}
	
	}
	
	event OnLeaveState( nextStateName : name )
	{
	}
}